#include <afx.h>
#include <afxtempl.h>
#include "input.h"
#include "errmsg.h"
#include "parse.h"

/**************************************************************************/

//@doc FILE ADINPUT

//@mfunc Constructs the input file object, zeroes the line
// buffer.

CAdInput::CAdInput(void)
{
	ZeroMem(&m_szLineBuf, MAXLINEBUFSIZE+1);
	m_lCurLine 	= 0;
	m_nAdState.Reuse = FALSE;
    m_nAdState.Append = FALSE;
	m_nAdState.EndOfFile = FALSE;
	m_chLineContChar = NULL;
}




/***********************************************************/
// Input operations
/***********************************************************/

//@mfunc Gets a line from the input file and stores it in
// <md .m_szLineBuf>. If the Reuse state is set in <md .m_nAdState>
// the function simply returns without refreshing the buffer.
//
//@rdesc Zero or a file exception error from <c CFileException>.

int CAdInput::GetLine(void)
{
TRY
{
	ASSERT(m_hFile != NULL);
    char *sz;
    int  n;

	if(m_nAdState.Reuse)
	{
		m_nAdState.Reuse = FALSE;
		return 0;
	}

    if(m_nAdState.Append)
    {
        m_nAdState.Append = FALSE;

        n = strlen(m_szLineBuf);

		// If there was a carriage return at end, overwrite it -
		// will treat this entire series as a single line for
		// easier parsing later.

		if(n >= 2 && m_szLineBuf[n-1] == '\n')
		{
			n--;
			m_szLineBuf[n-1] = chSpace;
		}

        if(MAXLINEBUFSIZE - n <= 0) 
            return errMultilineOverflow;

        sz = m_szLineBuf + n;
    }
    else
    {
		ZeroMem(m_szLineBuf, MAXLINEBUFSIZE+1);

        n = 0;
        sz = m_szLineBuf;
    }

	if(ReadString(sz, MAXLINEBUFSIZE - n) == NULL)
		m_nAdState.EndOfFile = TRUE;
    
	m_lCurLine++;

	// Check to see if there is a line continuation character here.

	char *szLineCont;

	if(m_chLineContChar && 
		(szLineCont = strchr(sz, m_chLineContChar)))
	{
		m_nAdState.Append = TRUE;
		*szLineCont = NULL;

		return GetLine();
	}

	m_szLineCur = sz;
        
    return 0;
}
CATCH(CFileException, e)
{
    return e->m_cause;
}
END_CATCH
}


//@mfunc Resets the <md .m_nAdState> variable.

void CAdInput::ResetState(void)
{
    ZeroMem(&m_nAdState, sizeof(m_nAdState)); 
}
